<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Dtos\Traits;

trait TraitStringListDTO
{
    /*
    |--------------------------------------------------------------------------
    | data
    |--------------------------------------------------------------------------
    */

    /**
     * @var string[] 
     */
    private $entries;

    /*
    |--------------------------------------------------------------------------
    | constructor without promoted properties, helps static analysis
    |--------------------------------------------------------------------------
    */

    /**
     * @param string[] $entries 
     */
    public function __construct($entries = array())
    {
        $this -> entries = \array_values($entries);
    }

    /*
    |--------------------------------------------------------------------------
    | from json map
    |--------------------------------------------------------------------------
    */

    /**
     * @return static 
     */
    public static function fromJsonMap(array $data)
    {
        return new static($data);
    }

    /*
    |--------------------------------------------------------------------------
    | interface
    |--------------------------------------------------------------------------
    */

    public function containsIndex(string $Index): bool
    {
        return isset($this -> entries[$Index]);
    }

    public function containsValue(string $value): bool
    {
        return \in_array($value, $this -> entries);
    }

    public function get(string $Index, string $fallbackValue): string
    {
        return $this -> entries[$Index] ?? $fallbackValue;
    }

    /**
     * @return string[] 
     */
    public function getAll(): array
    {
        return $this -> entries;
    }

    public function set(string $index, string $value): void
    {
        $this -> entries[$index] = $value;
    }

    public function removeValue(string $value): void
    {
        if (($key = \array_search($value, $this -> entries)) !== false)
        {
            unset($this -> entries[$key]);
        }
    }

    public function push(string $value): void
    {
        $this -> entries[] = $value;
    }

    /*
    |--------------------------------------------------------------------------
    | serialization for json_encode
    |--------------------------------------------------------------------------
    */

    public function jsonSerialize()
    {
        return $this -> entries;
    }

    /*
    |--------------------------------------------------------------------------
    | implement DTO methods
    |--------------------------------------------------------------------------
    */

    public static function serialize($stringMapDTO): string
    {
        return \json_encode($stringMapDTO);
    }

    /**
     * @return static 
     */
    public static function deSerialize(string $stringMapDTO)
    {
        $data = \json_decode($stringMapDTO, true);

        return static::fromJsonMap($data);
    }
}
